'----------------------------------------------------------------------------
'     MODULE NAME:   BugDetectionForShortNameAttribute.vbs
'
'         $Author:   USER "Dennis"  $
'       $Revision:   1.4  $
'           $Date:   12 Dec 2004 13:38:02  $
'        $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/BugDetectionForShortNameAttribute.vbs.pvcs  $
'
'     DESCRIPTION:   Looks for Windows .ShortName" bug.
'                    This VBS must have an invalid (log is easiest) 8.3 name
'                    and so should the name of the folder containing it.
'                    This script will then get shortnames for both and check
'                    if they are valid 8.3 names.
'----------------------------------------------------------------------------


'--- Initialization ---------------------------------------------------------
dim PgmVersion : PgmVersion = "04.345"
on error goto 0
set oFS     = MkObject("Scripting.FileSystemObject")
set oShell  = MkObject("WScript.Shell")
const RegNtfs83NamesTurnedOff = "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem\NtfsDisable8dot3NameCreation"

'--- Get name of this script ------------------------------------------------
ScriptName = WScript.ScriptFullName


'--- Now Create Both a File and Folder Object -------------------------------
set oFile  = oFS.GetFile(ScriptName)
set oDir   = oFS.GetFolder(oFS.GetParentFolderName(ScriptName))


'--- Get shortnames and see if OK -------------------------------------------
Name83     = oFile.ShortName
Path83     = oFile.ShortPath
DirName83  = oDir.ShortName
DirPath83  = oDir.ShortPath
Failed = false
if oFS.FileExists(Path83) and instr(Path83, " ") = 0 then
   Path83State = "OK"
   CheckWith   = oFS.GetFileName(Path83)
else
   Failed      = true
   CheckWith   = ""
   Path83State = "INVALID? - Doesn't seem to exist!"
end if
if  ValidShortName(Name83, CheckWith) then
    Name83State = "OK"
else
    Failed      = true
    Name83State = "INVALID 8.3 NAME"
end if
if oFS.FolderExists(DirPath83) and instr(DirPath83, " ") = 0 then
   DirPath83State = "OK"
   CheckWith   = oFS.GetFileName(DirPath83)
else
   Failed      = true
   CheckWith   = ""
   DirPath83State = "INVALID? - Doesn't seem to exist!"
end if
if  ValidShortName(DirName83, CheckWith) then
    DirName83State = "OK"
else
    Failed      = true
    DirName83State = "INVALID 8.3 NAME"
end if

'--- Start the report... ----------------------------------------------------
T = "The name of this script is """ & ScriptName & """"                         & vbCRLF & vbCRLF
T = T & "Its shortpath (8.3) is """ & Path83 & """ ("    & Path83State & ")"    & vbCRLF
T = T & "Its shortname (8.3) is """ & Name83 & """ ("    & Name83State & ")"    & vbCRLF & vbCRLF
T = T & "The parent folder is """   & oDir.path & """"   & vbCRLF & vbCRLF
T = T & "Its shortpath (8.3) is """ & DirPath83 & """ (" & DirPath83State & ")" & vbCRLF
T = T & "Its shortname (8.3) is """ & DirName83 & """ (" & DirName83State & ")" & vbCRLF
if  Failed then
    T = T & vbCRLF & "The windows .ShortName() or .ShortPath() bug has been detected!" & vbCRLF
else
    T = T & vbCRLF & "No issues with .ShortName() or .ShortPath() detected!" & vbCRLF
end if


'--- Check if NTFS is turned off! -------------------------------------------
on error resume next
TurnedOff = oShell.RegRead(RegNtfs83NamesTurnedOff)
if  err.number <> 0 then
    NtfsState = "Warning: Can't determine whether or not NTFS shortnames are turned off. Reason: 0x" & hex(err.number) & " - " & err.description
    Failed    = true
else
    if  cint(TurnedOff) <> 0 then
        NtfsState = "Warning: NTFS shortnames ARE turned off (at """ & RegNtfs83NamesTurnedOff & """)!" & vbCRLF & "Only newly created files or folders will be without valid ShortName information."
        Failed    = true
    else
        NtfsState = "NTFS shortnames are not turned off (at """ & RegNtfs83NamesTurnedOff & """)."
    end if
end if
T = T & vbCRLF & vbCRLF & NtfsState


'--- Display the message ----------------------------------------------------
if  Failed then
    Icon = vbCritical
else
    Icon = vbInformation
    if Wscript.Arguments.Count = 1 then if ucase(Wscript.Arguments(0)) = "SILENT" then wscript.quit(0)
end if
MsgBox T, Icon, "Have .ShortName() bug? - v" & PgmVersion


'--- Finish up --------------------------------------------------------------
set oFile  = Nothing
set oDir  = Nothing


'============================================================================
function ValidShortName(ShortName, KnownValid83Name)
'============================================================================
    '--- Look for Windows Bug -----------------------------------------------
    dim Bits83
    ValidShortName = true
    Bits83 = split(ShortName, ".")
    if  ubound(Bits83) > 1 then
        '--- Only one "." allowed! ------------------------------------------
        ValidShortName = false
    else
        '--- Check the "8" part of the "8.3" filename -----------------------
        if  len(Bits83(0)) > 8 then
            ValidShortName = false
        else
            '--- Check the "3" part (if any) of the "8.3" filename ----------
            if  ubound(Bits83) = 1 then
                '--- There is an extension ----------------------------------
                if  len(Bits83(1)) > 3 then
                    ValidShortName = false
                end if
            end if
        end if
    end if
    if  ValidShortName and instr(ShortName, " ") <> 0 then
        '--- Log script name contains a space, does the short one? ----------
        ValidShortName = false
    end if

    '--- We may already know what it should be... ---------------------------
    if  ValidShortName and KnownValid83Name <> "" then
        if  ucase(ShortName) <> ucase(KnownValid83Name) then
            ValidShortName = false
        end if
    end if
end function


'============================================================================
function MkObject(ByVal AutomationClass)   'Create object, die on error
'============================================================================
   on error resume next
   set MkObject = CreateObject(AutomationClass)
   if  err.number <> 0 then
       MsgBox "Failed loading the automation class """ & AutomationClass & """." & vbCRLF & "This is likely to be due to a Windows configuration problem of some type." & vbCRLF & vbCRLF & "Reason 0x" & hex(err.number) & " - " & err.description, vbCritical, "CAN'T PERFORM REQUIRED VALIDATION!"
       wscript.quit 555
   end if
end function
